"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceTypesController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const service_types_service_1 = require("./service_types.service");
const create_service_type_dto_1 = require("./dto/create-service_type.dto");
const update_service_type_dto_1 = require("./dto/update-service_type.dto");
const generic_response_dto_1 = require("../../dto/generic-response.dto");
let ServiceTypesController = class ServiceTypesController {
    constructor(serviceTypesService) {
        this.serviceTypesService = serviceTypesService;
    }
    async create(createServiceTypeDto) {
        try {
            const data = await this.serviceTypesService.create(createServiceTypeDto);
            return { success: true, data };
        }
        catch (error) {
            return { success: false, error: error.message };
        }
    }
    async findAll() {
        try {
            const data = await this.serviceTypesService.findAll();
            return { success: true, data };
        }
        catch (error) {
            return { success: false, error: error.message };
        }
    }
    async findOne(id) {
        try {
            const data = await this.serviceTypesService.findOne(id);
            return data ? { success: true, data } : { success: false, error: 'Service type not found.' };
        }
        catch (error) {
            return { success: false, error: error.message };
        }
    }
    async update(id, updateServiceTypeDto) {
        try {
            const data = await this.serviceTypesService.update(id, updateServiceTypeDto);
            return data ? { success: true, data } : { success: false, error: 'Service type not found.' };
        }
        catch (error) {
            return { success: false, error: error.message };
        }
    }
    async remove(id) {
        try {
            await this.serviceTypesService.remove(id);
            return { success: true };
        }
        catch (error) {
            return { success: false, error: error.message };
        }
    }
};
exports.ServiceTypesController = ServiceTypesController;
__decorate([
    (0, common_1.Post)(),
    (0, swagger_1.ApiOperation)({ summary: 'Create a new service type' }),
    (0, swagger_1.ApiResponse)({ status: 201, description: 'The service type has been successfully created.', type: (generic_response_dto_1.GenericResponse) }),
    (0, swagger_1.ApiResponse)({ status: 400, description: 'Bad Request.', type: (generic_response_dto_1.GenericResponse) }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_service_type_dto_1.CreateServiceTypeDto]),
    __metadata("design:returntype", Promise)
], ServiceTypesController.prototype, "create", null);
__decorate([
    (0, common_1.Get)(),
    (0, swagger_1.ApiOperation)({ summary: 'Get all service types' }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'Successful', type: (generic_response_dto_1.GenericResponse) }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], ServiceTypesController.prototype, "findAll", null);
__decorate([
    (0, common_1.Get)(':id'),
    (0, swagger_1.ApiOperation)({ summary: 'Get a service type by ID' }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'Successful', type: (generic_response_dto_1.GenericResponse) }),
    (0, swagger_1.ApiResponse)({ status: 404, description: 'Service type not found.', type: (generic_response_dto_1.GenericResponse) }),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], ServiceTypesController.prototype, "findOne", null);
__decorate([
    (0, common_1.Patch)(':id'),
    (0, swagger_1.ApiOperation)({ summary: 'Update a service type' }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'The service type has been successfully updated.', type: (generic_response_dto_1.GenericResponse) }),
    (0, swagger_1.ApiResponse)({ status: 404, description: 'Service type not found.', type: (generic_response_dto_1.GenericResponse) }),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, update_service_type_dto_1.UpdateServiceTypeDto]),
    __metadata("design:returntype", Promise)
], ServiceTypesController.prototype, "update", null);
__decorate([
    (0, common_1.Delete)(':id'),
    (0, swagger_1.ApiOperation)({ summary: 'Delete a service type' }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'The service type has been successfully deleted.', type: (generic_response_dto_1.GenericResponse) }),
    (0, swagger_1.ApiResponse)({ status: 404, description: 'Service type not found.', type: (generic_response_dto_1.GenericResponse) }),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], ServiceTypesController.prototype, "remove", null);
exports.ServiceTypesController = ServiceTypesController = __decorate([
    (0, swagger_1.ApiTags)('service_types'),
    (0, common_1.Controller)('service_types'),
    __metadata("design:paramtypes", [service_types_service_1.ServiceTypesService])
], ServiceTypesController);
//# sourceMappingURL=service_types.controller.js.map