"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.RolesController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const roles_service_1 = require("./roles.service");
const create_role_dto_1 = require("./dto/create-role.dto");
const update_role_dto_1 = require("./dto/update-role.dto");
const generic_response_dto_1 = require("../../dto/generic-response.dto");
let RolesController = class RolesController {
    constructor(rolesService) {
        this.rolesService = rolesService;
    }
    async create(createRoleDto) {
        try {
            const data = await this.rolesService.create(createRoleDto);
            return { success: true, data };
        }
        catch (error) {
            return { success: false, error: error.message };
        }
    }
    async findAll() {
        try {
            const data = await this.rolesService.findAll();
            return { success: true, data };
        }
        catch (error) {
            return { success: false, error: error.message };
        }
    }
    async findOne(id) {
        try {
            const data = await this.rolesService.findOne(+id);
            return data ? { success: true, data } : { success: false, error: 'Role not found.' };
        }
        catch (error) {
            return { success: false, error: error.message };
        }
    }
    async update(id, updateRoleDto) {
        try {
            const data = await this.rolesService.update(+id, updateRoleDto);
            return data ? { success: true, data } : { success: false, error: 'Role not found.' };
        }
        catch (error) {
            return { success: false, error: error.message };
        }
    }
    async remove(id) {
        try {
            await this.rolesService.remove(+id);
            return { success: true };
        }
        catch (error) {
            return { success: false, error: error.message };
        }
    }
};
exports.RolesController = RolesController;
__decorate([
    (0, common_1.Post)(),
    (0, swagger_1.ApiOperation)({ summary: 'Create a new role' }),
    (0, swagger_1.ApiResponse)({ status: 201, description: 'The role has been successfully created.', type: (generic_response_dto_1.GenericResponse) }),
    (0, swagger_1.ApiResponse)({ status: 400, description: 'Bad Request.', type: (generic_response_dto_1.GenericResponse) }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_role_dto_1.CreateRoleDto]),
    __metadata("design:returntype", Promise)
], RolesController.prototype, "create", null);
__decorate([
    (0, common_1.Get)(),
    (0, swagger_1.ApiOperation)({ summary: 'Get all roles' }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'Return all roles.', type: (generic_response_dto_1.GenericResponse) }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], RolesController.prototype, "findAll", null);
__decorate([
    (0, common_1.Get)(':id'),
    (0, swagger_1.ApiOperation)({ summary: 'Get a role by ID' }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'Return the role with the given ID.', type: (generic_response_dto_1.GenericResponse) }),
    (0, swagger_1.ApiResponse)({ status: 404, description: 'Role not found.', type: (generic_response_dto_1.GenericResponse) }),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], RolesController.prototype, "findOne", null);
__decorate([
    (0, common_1.Patch)(':id'),
    (0, swagger_1.ApiOperation)({ summary: 'Update a role by ID' }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'The role has been successfully updated.', type: (generic_response_dto_1.GenericResponse) }),
    (0, swagger_1.ApiResponse)({ status: 404, description: 'Role not found.', type: (generic_response_dto_1.GenericResponse) }),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String, update_role_dto_1.UpdateRoleDto]),
    __metadata("design:returntype", Promise)
], RolesController.prototype, "update", null);
__decorate([
    (0, common_1.Delete)(':id'),
    (0, swagger_1.ApiOperation)({ summary: 'Delete a role by ID' }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'The role has been successfully deleted.', type: (generic_response_dto_1.GenericResponse) }),
    (0, swagger_1.ApiResponse)({ status: 404, description: 'Role not found.', type: (generic_response_dto_1.GenericResponse) }),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [String]),
    __metadata("design:returntype", Promise)
], RolesController.prototype, "remove", null);
exports.RolesController = RolesController = __decorate([
    (0, swagger_1.ApiTags)('roles'),
    (0, common_1.Controller)('roles'),
    __metadata("design:paramtypes", [roles_service_1.RolesService])
], RolesController);
//# sourceMappingURL=roles.controller.js.map