"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LeadsController = void 0;
const common_1 = require("@nestjs/common");
const leads_service_1 = require("./leads.service");
const create_lead_dto_1 = require("./dto/create-lead.dto");
const update_lead_dto_1 = require("./dto/update-lead.dto");
const swagger_1 = require("@nestjs/swagger");
const generic_response_dto_1 = require("../../dto/generic-response.dto");
let LeadsController = class LeadsController {
    constructor(leadsService) {
        this.leadsService = leadsService;
    }
    async create(createLeadDto) {
        try {
            const data = await this.leadsService.create(createLeadDto);
            return { success: true, data };
        }
        catch (error) {
            return { success: false, error: error.message };
        }
    }
    async findAll() {
        try {
            const data = await this.leadsService.findAll();
            return { success: true, data };
        }
        catch (error) {
            return { success: false, error: error.message };
        }
    }
    async findOne(id) {
        try {
            const data = await this.leadsService.findOne(id);
            return data ? { success: true, data } : { success: false, error: 'Lead not found' };
        }
        catch (error) {
            return { success: false, error: error.message };
        }
    }
    async update(id, updateLeadDto) {
        try {
            const data = await this.leadsService.update(id, updateLeadDto);
            return data ? { success: true, data } : { success: false, error: 'Lead not found' };
        }
        catch (error) {
            return { success: false, error: error.message };
        }
    }
    async remove(id) {
        try {
            await this.leadsService.remove(id);
            return { success: true };
        }
        catch (error) {
            return { success: false, error: error.message };
        }
    }
};
exports.LeadsController = LeadsController;
__decorate([
    (0, common_1.Post)(),
    (0, swagger_1.ApiOperation)({ summary: 'Create a new lead' }),
    (0, swagger_1.ApiBody)({ type: create_lead_dto_1.CreateLeadDto }),
    (0, swagger_1.ApiResponse)({ status: 201, description: 'The lead has been successfully created.', type: (generic_response_dto_1.GenericResponse) }),
    (0, swagger_1.ApiResponse)({ status: 400, description: 'Bad Request', type: (generic_response_dto_1.GenericResponse) }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_lead_dto_1.CreateLeadDto]),
    __metadata("design:returntype", Promise)
], LeadsController.prototype, "create", null);
__decorate([
    (0, common_1.Get)(),
    (0, swagger_1.ApiOperation)({ summary: 'Get all leads' }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'Return all leads', type: (generic_response_dto_1.GenericResponse) }),
    (0, swagger_1.ApiResponse)({ status: 404, description: 'No leads found', type: (generic_response_dto_1.GenericResponse) }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], LeadsController.prototype, "findAll", null);
__decorate([
    (0, common_1.Get)(':id'),
    (0, swagger_1.ApiOperation)({ summary: 'Get a lead by ID' }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'Return a single lead', type: (generic_response_dto_1.GenericResponse) }),
    (0, swagger_1.ApiResponse)({ status: 404, description: 'Lead not found', type: (generic_response_dto_1.GenericResponse) }),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], LeadsController.prototype, "findOne", null);
__decorate([
    (0, common_1.Put)(':id'),
    (0, swagger_1.ApiOperation)({ summary: 'Update a lead by ID' }),
    (0, swagger_1.ApiBody)({ type: update_lead_dto_1.UpdateLeadDto }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'The lead has been successfully updated.', type: (generic_response_dto_1.GenericResponse) }),
    (0, swagger_1.ApiResponse)({ status: 404, description: 'Lead not found', type: (generic_response_dto_1.GenericResponse) }),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, update_lead_dto_1.UpdateLeadDto]),
    __metadata("design:returntype", Promise)
], LeadsController.prototype, "update", null);
__decorate([
    (0, common_1.Delete)(':id'),
    (0, swagger_1.ApiOperation)({ summary: 'Delete a lead by ID' }),
    (0, swagger_1.ApiResponse)({ status: 204, description: 'The lead has been successfully deleted.', type: (generic_response_dto_1.GenericResponse) }),
    (0, swagger_1.ApiResponse)({ status: 404, description: 'Lead not found', type: (generic_response_dto_1.GenericResponse) }),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], LeadsController.prototype, "remove", null);
exports.LeadsController = LeadsController = __decorate([
    (0, swagger_1.ApiTags)('leads'),
    (0, common_1.Controller)('leads'),
    __metadata("design:paramtypes", [leads_service_1.LeadsService])
], LeadsController);
//# sourceMappingURL=leads.controller.js.map