"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LawyersService = void 0;
const common_1 = require("@nestjs/common");
const typeorm_1 = require("@nestjs/typeorm");
const typeorm_2 = require("typeorm");
const lawyer_entity_1 = require("./entities/lawyer.entity");
const bcrypt = require("bcryptjs");
let LawyersService = class LawyersService {
    constructor(lawyersRepository) {
        this.lawyersRepository = lawyersRepository;
    }
    async create(createLawyerDto) {
        const hashedPassword = await bcrypt.hash(createLawyerDto.password, 10);
        const lawyer = this.lawyersRepository.create({
            ...createLawyerDto,
            password: hashedPassword,
        });
        return this.lawyersRepository.save(lawyer);
    }
    async findAll() {
        return this.lawyersRepository.find({ relations: ['service_type', 'role'] });
    }
    async findOne(id) {
        const lawyer = await this.lawyersRepository.findOne({ where: { id }, relations: ['service_type', 'role'] });
        if (!lawyer) {
            throw new common_1.NotFoundException(`Lawyer with ID ${id} not found.`);
        }
        return lawyer;
    }
    async findByEmail(email) {
        const lawyer = await this.lawyersRepository.findOne({
            where: { email },
            relations: ['service_type', 'role'],
        });
        if (!lawyer) {
            throw new common_1.NotFoundException(`Lawyer with email ${email} not found.`);
        }
        return lawyer;
    }
    async update(id, updateLawyerDto) {
        if (updateLawyerDto.password) {
            updateLawyerDto.password = await bcrypt.hash(updateLawyerDto.password, 10);
        }
        await this.lawyersRepository.update(id, updateLawyerDto);
        return this.findOne(id);
    }
    async updatePassword(id, newPassword) {
        const hashedPassword = await bcrypt.hash(newPassword, 10);
        await this.lawyersRepository.update(id, { password: hashedPassword });
        return this.findOne(id);
    }
    async remove(id) {
        const lawyer = await this.findOne(id);
        await this.lawyersRepository.softRemove(lawyer);
    }
};
exports.LawyersService = LawyersService;
exports.LawyersService = LawyersService = __decorate([
    (0, common_1.Injectable)(),
    __param(0, (0, typeorm_1.InjectRepository)(lawyer_entity_1.Lawyer)),
    __metadata("design:paramtypes", [typeorm_2.Repository])
], LawyersService);
//# sourceMappingURL=lawyers.service.js.map