import { Repository } from 'typeorm';
import { Lawyer } from './entities/lawyer.entity';
import { CreateLawyerDto } from './dto/create-lawyer.dto';
import { UpdateLawyerDto } from './dto/update-lawyer.dto';
export declare class LawyersService {
    private readonly lawyersRepository;
    constructor(lawyersRepository: Repository<Lawyer>);
    create(createLawyerDto: CreateLawyerDto): Promise<Lawyer>;
    findAll(): Promise<Lawyer[]>;
    findOne(id: number): Promise<Lawyer>;
    findByEmail(email: string): Promise<Lawyer>;
    update(id: number, updateLawyerDto: UpdateLawyerDto): Promise<Lawyer>;
    updatePassword(id: number, newPassword: string): Promise<Lawyer>;
    remove(id: number): Promise<void>;
}
