"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
var __param = (this && this.__param) || function (paramIndex, decorator) {
    return function (target, key) { decorator(target, key, paramIndex); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.LawyersController = void 0;
const common_1 = require("@nestjs/common");
const swagger_1 = require("@nestjs/swagger");
const lawyers_service_1 = require("./lawyers.service");
const create_lawyer_dto_1 = require("./dto/create-lawyer.dto");
const update_lawyer_dto_1 = require("./dto/update-lawyer.dto");
const generic_response_dto_1 = require("../../dto/generic-response.dto");
let LawyersController = class LawyersController {
    constructor(lawyersService) {
        this.lawyersService = lawyersService;
    }
    async create(createLawyerDto) {
        try {
            const data = await this.lawyersService.create(createLawyerDto);
            return { success: true, data };
        }
        catch (error) {
            return { success: false, error: error.message };
        }
    }
    async findAll() {
        try {
            const data = await this.lawyersService.findAll();
            return { success: true, data };
        }
        catch (error) {
            return { success: false, error: error.message };
        }
    }
    async findOne(id) {
        try {
            const data = await this.lawyersService.findOne(id);
            return data ? { success: true, data } : { success: false, error: 'Lawyer not found' };
        }
        catch (error) {
            return { success: false, error: error.message };
        }
    }
    async update(id, updateLawyerDto) {
        try {
            const data = await this.lawyersService.update(id, updateLawyerDto);
            return data ? { success: true, data } : { success: false, error: 'Lawyer not found' };
        }
        catch (error) {
            return { success: false, error: error.message };
        }
    }
    async remove(id) {
        try {
            await this.lawyersService.remove(id);
            return { success: true };
        }
        catch (error) {
            return { success: false, error: error.message };
        }
    }
};
exports.LawyersController = LawyersController;
__decorate([
    (0, common_1.Post)(),
    (0, swagger_1.ApiOperation)({ summary: 'Create a new lawyer' }),
    (0, swagger_1.ApiResponse)({ status: 201, description: 'The lawyer has been successfully created.', type: (generic_response_dto_1.GenericResponse) }),
    (0, swagger_1.ApiResponse)({ status: 403, description: 'Forbidden.', type: (generic_response_dto_1.GenericResponse) }),
    __param(0, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [create_lawyer_dto_1.CreateLawyerDto]),
    __metadata("design:returntype", Promise)
], LawyersController.prototype, "create", null);
__decorate([
    (0, common_1.Get)(),
    (0, swagger_1.ApiOperation)({ summary: 'Get all lawyers' }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'Return all lawyers.', type: (generic_response_dto_1.GenericResponse) }),
    (0, swagger_1.ApiResponse)({ status: 404, description: 'No lawyers found.', type: (generic_response_dto_1.GenericResponse) }),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", []),
    __metadata("design:returntype", Promise)
], LawyersController.prototype, "findAll", null);
__decorate([
    (0, common_1.Get)(':id'),
    (0, swagger_1.ApiOperation)({ summary: 'Get a lawyer by ID' }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'Return a lawyer.', type: (generic_response_dto_1.GenericResponse) }),
    (0, swagger_1.ApiResponse)({ status: 404, description: 'Lawyer not found.', type: (generic_response_dto_1.GenericResponse) }),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], LawyersController.prototype, "findOne", null);
__decorate([
    (0, common_1.Put)(':id'),
    (0, swagger_1.ApiOperation)({ summary: 'Update a lawyer' }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'The lawyer has been successfully updated.', type: (generic_response_dto_1.GenericResponse) }),
    (0, swagger_1.ApiResponse)({ status: 404, description: 'Lawyer not found.', type: (generic_response_dto_1.GenericResponse) }),
    __param(0, (0, common_1.Param)('id')),
    __param(1, (0, common_1.Body)()),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number, update_lawyer_dto_1.UpdateLawyerDto]),
    __metadata("design:returntype", Promise)
], LawyersController.prototype, "update", null);
__decorate([
    (0, common_1.Delete)(':id'),
    (0, swagger_1.ApiOperation)({ summary: 'Delete a lawyer' }),
    (0, swagger_1.ApiResponse)({ status: 200, description: 'The lawyer has been successfully deleted.', type: (generic_response_dto_1.GenericResponse) }),
    (0, swagger_1.ApiResponse)({ status: 404, description: 'Lawyer not found.', type: (generic_response_dto_1.GenericResponse) }),
    __param(0, (0, common_1.Param)('id')),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [Number]),
    __metadata("design:returntype", Promise)
], LawyersController.prototype, "remove", null);
exports.LawyersController = LawyersController = __decorate([
    (0, swagger_1.ApiTags)('lawyers'),
    (0, common_1.Controller)('lawyers'),
    __metadata("design:paramtypes", [lawyers_service_1.LawyersService])
], LawyersController);
//# sourceMappingURL=lawyers.controller.js.map