"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Lawyer = void 0;
const typeorm_1 = require("typeorm");
const swagger_1 = require("@nestjs/swagger");
const service_type_entity_1 = require("../../service_types/entities/service_type.entity");
const role_entity_1 = require("../../roles/entities/role.entity");
let Lawyer = class Lawyer {
};
exports.Lawyer = Lawyer;
__decorate([
    (0, typeorm_1.PrimaryGeneratedColumn)(),
    (0, swagger_1.ApiProperty)({ example: 1, description: 'The unique identifier of the lawyer' }),
    __metadata("design:type", Number)
], Lawyer.prototype, "id", void 0);
__decorate([
    (0, typeorm_1.Column)(),
    (0, swagger_1.ApiProperty)({ example: 'John', description: 'The first name of the lawyer' }),
    __metadata("design:type", String)
], Lawyer.prototype, "firstName", void 0);
__decorate([
    (0, typeorm_1.Column)(),
    (0, swagger_1.ApiProperty)({ example: 'Doe', description: 'The last name of the lawyer' }),
    __metadata("design:type", String)
], Lawyer.prototype, "lastName", void 0);
__decorate([
    (0, typeorm_1.Column)(),
    (0, swagger_1.ApiProperty)({ example: 'john.doe@example.com', description: 'The email of the lawyer' }),
    __metadata("design:type", String)
], Lawyer.prototype, "email", void 0);
__decorate([
    (0, typeorm_1.Column)(),
    (0, swagger_1.ApiProperty)({ example: '123456789', description: 'The phone number of the lawyer' }),
    __metadata("design:type", String)
], Lawyer.prototype, "phone", void 0);
__decorate([
    (0, typeorm_1.Column)(),
    (0, swagger_1.ApiProperty)({ example: 'password123', description: 'The password of the lawyer' }),
    __metadata("design:type", String)
], Lawyer.prototype, "password", void 0);
__decorate([
    (0, typeorm_1.Column)(),
    (0, swagger_1.ApiProperty)({ example: 'ABCD1234', description: 'The unique code of the lawyer' }),
    __metadata("design:type", String)
], Lawyer.prototype, "code", void 0);
__decorate([
    (0, typeorm_1.Column)(),
    (0, swagger_1.ApiProperty)({ example: 10, description: 'The maximum number of leads the lawyer can handle' }),
    __metadata("design:type", Number)
], Lawyer.prototype, "max_leads", void 0);
__decorate([
    (0, typeorm_1.Column)(),
    (0, swagger_1.ApiProperty)({ example: true, description: 'Whether the lawyer is active or not' }),
    __metadata("design:type", Boolean)
], Lawyer.prototype, "is_active", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'timestamp', default: () => 'CURRENT_TIMESTAMP' }),
    (0, swagger_1.ApiProperty)({ example: '2023-01-01', description: 'The creation date of the lawyer' }),
    __metadata("design:type", Date)
], Lawyer.prototype, "created_at", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'timestamp', default: () => 'CURRENT_TIMESTAMP' }),
    (0, swagger_1.ApiProperty)({ example: '2023-01-01', description: 'The last update date of the lawyer' }),
    __metadata("design:type", Date)
], Lawyer.prototype, "updated_at", void 0);
__decorate([
    (0, typeorm_1.Column)({ type: 'date', nullable: true }),
    (0, swagger_1.ApiProperty)({ example: '2023-01-01', description: 'The last login date of the lawyer' }),
    __metadata("design:type", Date)
], Lawyer.prototype, "last_login", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => service_type_entity_1.ServiceType),
    (0, typeorm_1.JoinColumn)({ name: 'service_type_id' }),
    __metadata("design:type", service_type_entity_1.ServiceType)
], Lawyer.prototype, "service_type", void 0);
__decorate([
    (0, typeorm_1.ManyToOne)(() => role_entity_1.Role),
    (0, typeorm_1.JoinColumn)({ name: 'role_id' }),
    __metadata("design:type", role_entity_1.Role)
], Lawyer.prototype, "role", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: 'service_type_id' }),
    __metadata("design:type", Number)
], Lawyer.prototype, "service_type_id", void 0);
__decorate([
    (0, typeorm_1.Column)({ name: 'role_id' }),
    __metadata("design:type", Number)
], Lawyer.prototype, "role_id", void 0);
__decorate([
    (0, typeorm_1.DeleteDateColumn)({ name: 'deleted_at', type: 'timestamp', nullable: true }),
    (0, swagger_1.ApiProperty)({ example: '2023-01-01', description: 'The deletion date of the lawyer' }),
    __metadata("design:type", Date)
], Lawyer.prototype, "deleted_at", void 0);
exports.Lawyer = Lawyer = __decorate([
    (0, typeorm_1.Entity)()
], Lawyer);
//# sourceMappingURL=lawyer.entity.js.map