"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.UpdateLawyerDto = void 0;
const swagger_1 = require("@nestjs/swagger");
const class_validator_1 = require("class-validator");
const create_lawyer_dto_1 = require("./create-lawyer.dto");
class UpdateLawyerDto extends (0, swagger_1.PartialType)(create_lawyer_dto_1.CreateLawyerDto) {
}
exports.UpdateLawyerDto = UpdateLawyerDto;
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    (0, swagger_1.ApiProperty)({ example: 'John', description: 'The first name of the lawyer', required: false }),
    __metadata("design:type", String)
], UpdateLawyerDto.prototype, "firstName", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    (0, swagger_1.ApiProperty)({ example: 'Doe', description: 'The last name of the lawyer', required: false }),
    __metadata("design:type", String)
], UpdateLawyerDto.prototype, "lastName", void 0);
__decorate([
    (0, class_validator_1.IsEmail)(),
    (0, class_validator_1.IsOptional)(),
    (0, swagger_1.ApiProperty)({ example: 'john.doe@example.com', description: 'The email of the lawyer', required: false }),
    __metadata("design:type", String)
], UpdateLawyerDto.prototype, "email", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    (0, swagger_1.ApiProperty)({ example: '123456789', description: 'The phone number of the lawyer', required: false }),
    __metadata("design:type", String)
], UpdateLawyerDto.prototype, "phone", void 0);
__decorate([
    (0, swagger_1.ApiProperty)({ example: 'ABCD1234', description: 'The unique code of the lawyer', required: false }),
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    __metadata("design:type", String)
], UpdateLawyerDto.prototype, "code", void 0);
__decorate([
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.IsOptional)(),
    (0, swagger_1.ApiProperty)({ example: 1, description: 'The service type ID of the lawyer', required: false }),
    __metadata("design:type", Number)
], UpdateLawyerDto.prototype, "service_type_id", void 0);
__decorate([
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.IsOptional)(),
    (0, swagger_1.ApiProperty)({ example: 1, description: 'The role ID of the lawyer', required: false }),
    __metadata("design:type", Number)
], UpdateLawyerDto.prototype, "role_id", void 0);
__decorate([
    (0, class_validator_1.IsString)(),
    (0, class_validator_1.IsOptional)(),
    (0, swagger_1.ApiProperty)({ example: 'password123', description: 'The password of the lawyer', required: false }),
    __metadata("design:type", String)
], UpdateLawyerDto.prototype, "password", void 0);
__decorate([
    (0, class_validator_1.IsNumber)(),
    (0, class_validator_1.IsOptional)(),
    (0, swagger_1.ApiProperty)({ example: 10, description: 'The maximum number of leads the lawyer can handle', required: false }),
    __metadata("design:type", Number)
], UpdateLawyerDto.prototype, "max_leads", void 0);
__decorate([
    (0, class_validator_1.IsBoolean)(),
    (0, class_validator_1.IsOptional)(),
    (0, swagger_1.ApiProperty)({ example: true, description: 'Whether the lawyer is active or not', required: false }),
    __metadata("design:type", Boolean)
], UpdateLawyerDto.prototype, "is_active", void 0);
//# sourceMappingURL=update-lawyer.dto.js.map