"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AuthService = void 0;
const common_1 = require("@nestjs/common");
const jwt_1 = require("@nestjs/jwt");
const lawyers_service_1 = require("../lawyers/lawyers.service");
const mail_service_1 = require("../../mail/mail.service");
const bcrypt = require("bcryptjs");
let AuthService = class AuthService {
    constructor(lawyersService, jwtService, mailService) {
        this.lawyersService = lawyersService;
        this.jwtService = jwtService;
        this.mailService = mailService;
    }
    async validateLawyer(email, password) {
        const lawyer = await this.lawyersService.findByEmail(email);
        if (lawyer && bcrypt.compareSync(password, lawyer.password)) {
            const { password, ...result } = lawyer;
            return result;
        }
        return null;
    }
    async login(email, password) {
        const lawyer = await this.validateLawyer(email, password);
        if (!lawyer) {
            throw new common_1.UnauthorizedException('Invalid credentials');
        }
        const payload = { email: lawyer.email, sub: lawyer.id };
        return {
            access_token: this.jwtService.sign(payload),
            lawyer,
        };
    }
    async requestPasswordReset(email) {
        const lawyer = await this.lawyersService.findByEmail(email);
        if (!lawyer) {
            throw new Error('User not found');
        }
        const token = this.jwtService.sign({ userId: lawyer.id }, { expiresIn: '1h' });
        await this.mailService.sendResetPasswordEmail(email, token);
    }
    async resetPassword(token, newPassword) {
        const payload = this.jwtService.verify(token);
        const lawyer = await this.lawyersService.findOne(payload.userId);
        if (!lawyer) {
            throw new Error('Invalid token');
        }
        const hashedPassword = await bcrypt.hash(newPassword, 10);
        await this.lawyersService.updatePassword(lawyer.id, hashedPassword);
    }
};
exports.AuthService = AuthService;
exports.AuthService = AuthService = __decorate([
    (0, common_1.Injectable)(),
    __metadata("design:paramtypes", [lawyers_service_1.LawyersService,
        jwt_1.JwtService,
        mail_service_1.MailService])
], AuthService);
//# sourceMappingURL=auth.service.js.map