"use strict";
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.AppModule = void 0;
const common_1 = require("@nestjs/common");
const config_1 = require("@nestjs/config");
const typeorm_1 = require("@nestjs/typeorm");
const app_controller_1 = require("./app.controller");
const app_service_1 = require("./app.service");
const lawyers_module_1 = require("./modules/lawyers/lawyers.module");
const configuration_1 = require("./config/configuration");
const service_types_module_1 = require("./modules/service_types/service_types.module");
const roles_module_1 = require("./modules/roles/roles.module");
const auth_module_1 = require("./modules/auth/auth.module");
const leads_module_1 = require("./modules/leads/leads.module");
let AppModule = class AppModule {
};
exports.AppModule = AppModule;
exports.AppModule = AppModule = __decorate([
    (0, common_1.Module)({
        imports: [
            config_1.ConfigModule.forRoot({
                load: [configuration_1.default],
                isGlobal: true,
            }),
            typeorm_1.TypeOrmModule.forRootAsync({
                name: 'default',
                imports: [config_1.ConfigModule],
                inject: [config_1.ConfigService],
                useFactory: (configService) => ({
                    type: 'mysql',
                    host: configService.get('database.host'),
                    port: configService.get('database.port'),
                    username: configService.get('database.username'),
                    password: configService.get('database.password'),
                    database: configService.get('database.database'),
                    entities: [
                        __dirname + '/modules/roles/entities/*.entity{.ts,.js}',
                        __dirname + '/modules/service_types/entities/*.entity{.ts,.js}',
                        __dirname + '/modules/lawyers/entities/*.entity{.ts,.js}'
                    ],
                    synchronize: true,
                }),
            }),
            typeorm_1.TypeOrmModule.forRootAsync({
                name: 'lawyersPruebaConnection',
                imports: [config_1.ConfigModule],
                inject: [config_1.ConfigService],
                useFactory: (configService) => ({
                    type: 'mysql',
                    host: configService.get('lawyersPruebaDatabase.host'),
                    port: configService.get('lawyersPruebaDatabase.port'),
                    username: configService.get('lawyersPruebaDatabase.username'),
                    password: configService.get('lawyersPruebaDatabase.password'),
                    database: configService.get('lawyersPruebaDatabase.database'),
                    entities: [
                        __dirname + '/modules/leads/entities/*.entity{.ts,.js}'
                    ],
                    synchronize: false,
                }),
            }),
            lawyers_module_1.LawyersModule,
            service_types_module_1.ServiceTypesModule,
            roles_module_1.RolesModule,
            auth_module_1.AuthModule,
            leads_module_1.LeadsModule,
        ],
        controllers: [app_controller_1.AppController],
        providers: [app_service_1.AppService],
    })
], AppModule);
//# sourceMappingURL=app.module.js.map